<?php
declare(strict_types=1);

/**
 * License integration layer (stub)
 *
 * WHMCS core API doesn't provide a universal licensing list endpoint.
 * Your options:
 * 1) Create a custom WHMCS addon/module that exposes license endpoints via WHMCS API
 *    and call it from here using whmcs_api([...]).
 * 2) Use a separate license system endpoint and call it with cURL from here.
 */

function license_list(int $clientId): array {
    // Example custom WHMCS API action:
    // $r = whmcs_api(['action'=>'GetLicenses','clientid'=>(string)$clientId]);
    // if (($r['result'] ?? '') === 'success') return ['result'=>'success','licenses'=>$r['licenses'] ?? []];

    return ['result'=>'error','message'=>'License API not configured. Wire it in src/license.php.'];
}

function license_get(int $clientId, string $id): array {
    // Example:
    // $r = whmcs_api(['action'=>'GetLicense','clientid'=>(string)$clientId,'id'=>$id]);
    // if (($r['result'] ?? '') === 'success') return ['result'=>'success','license'=>$r['license'] ?? []];

    return ['result'=>'error','message'=>'License API not configured.'];
}
