<?php
declare(strict_types=1);

function frilix_csrf_init(): void {
    if (empty($_SESSION['csrf'])) {
        $_SESSION['csrf'] = bin2hex(random_bytes(32));
    }
}
function frilix_csrf_token(): string {
    return $_SESSION['csrf'] ?? '';
}
function frilix_csrf_check(?string $token): bool {
    if (!$token) return false;
    return isset($_SESSION['csrf']) && hash_equals($_SESSION['csrf'], $token);
}

function is_logged_in(): bool {
    return !empty($_SESSION['client']['id']);
}

function require_login(): void {
    if (!is_logged_in()) {
        header('Location: login.php');
        exit;
    }
}

function e(string $s): string {
    return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
}

function money_fmt($amount, string $currency = ''): string {
    $a = is_numeric($amount) ? number_format((float)$amount, 2) : (string)$amount;
    return trim($currency . ' ' . $a);
}

function safe_int($v, int $default=0): int {
    if (is_numeric($v)) return (int)$v;
    return $default;
}

function app_url(string $path = ''): string {
    $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $base = rtrim(dirname($_SERVER['SCRIPT_NAME'] ?? '/'), '/\\');
    if ($base === '/') $base = '';
    return $scheme . '://' . $host . $base . '/' . ltrim($path, '/');
}
