<?php
declare(strict_types=1);

$config = require __DIR__ . '/../config/config.php';

// Sessions
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_name($config['session_name'] ?? 'frilix_cloud_portal');
    session_start();
}

// Security headers
header('X-Frame-Options: SAMEORIGIN');
header('X-Content-Type-Options: nosniff');
header('Referrer-Policy: strict-origin-when-cross-origin');
header('Permissions-Policy: geolocation=(), microphone=(), camera=()');

// Basic session hardening
ini_set('session.use_strict_mode', '1');
ini_set('session.cookie_httponly', '1');
if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') {
    ini_set('session.cookie_secure', '1');
}
ini_set('session.cookie_samesite', 'Lax');

require __DIR__ . '/helpers.php';
require __DIR__ . '/whmcs.php';

// CSRF
frilix_csrf_init();

// Flash helper
function flash(string $key, ?string $value = null) {
    if ($value === null) {
        $v = $_SESSION['_flash'][$key] ?? null;
        unset($_SESSION['_flash'][$key]);
        return $v;
    }
    $_SESSION['_flash'][$key] = $value;
    return null;
}
