<?php
declare(strict_types=1);
$title = 'Tickets';
require_once __DIR__ . '/partials/header.php';
require_login();

$clientId = (int)$_SESSION['client']['id'];
$status = trim((string)($_GET['status'] ?? ''));
$res = whmcs_get_tickets($clientId, 50, 0, $status);

$items = $res['tickets']['ticket'] ?? [];
if (!is_array($items)) $items = [];

function t_badge(string $status): array {
    $s = strtolower($status);
    if (in_array($s, ['open','customer-reply','answered','in progress'], true)) return [$status, 'badge badge--warn'];
    if (in_array($s, ['closed'], true)) return ['Closed', 'badge badge--ok'];
    return [$status, 'badge'];
}
?>
<div class="container">
  <div class="pagehead">
    <div>
      <h1>Tickets</h1>
      <p class="subtle">All your support tickets.</p>
    </div>
    <div class="btnrow">
      <a class="btn" href="ticket_new.php">➕ Open Ticket</a>
      <a class="btn btn--ghost" href="tickets.php">All</a>
      <a class="btn btn--ghost" href="tickets.php?status=Open">Open</a>
      <a class="btn btn--ghost" href="tickets.php?status=Closed">Closed</a>
    </div>
  </div>

  <?php if (($res['result'] ?? '') !== 'success'): ?>
    <div class="alert alert--danger"><strong>Error</strong><?= e($res['message'] ?? 'Failed to load tickets') ?></div>
  <?php else: ?>
    <div class="tablewrap">
      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th>Subject</th>
            <th>Department</th>
            <th>Last Reply</th>
            <th>Status</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
        <?php if (empty($items)): ?>
          <tr><td colspan="6">No tickets found.</td></tr>
        <?php else: foreach ($items as $t):
          $tid = safe_int($t['id'] ?? 0);
          [$label,$cls] = t_badge((string)($t['status'] ?? ''));
        ?>
          <tr>
            <td>#<?= e((string)$tid) ?></td>
            <td><?= e((string)($t['subject'] ?? '')) ?></td>
            <td><?= e((string)($t['deptname'] ?? '')) ?></td>
            <td><?= e((string)($t['lastreply'] ?? '')) ?></td>
            <td><span class="<?= e($cls) ?>"><?= e($label) ?></span></td>
            <td><a class="btn btn--ghost" href="ticket_view.php?id=<?= e((string)$tid) ?>">Open</a></td>
          </tr>
        <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
