<?php
declare(strict_types=1);
$title = 'Ticket';
require_once __DIR__ . '/partials/header.php';
require_login();

$id = safe_int($_GET['id'] ?? 0);
if ($id <= 0) { header('Location: tickets.php'); exit; }

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!frilix_csrf_check($_POST['csrf'] ?? null)) {
        $error = 'Invalid CSRF token.';
    } else {
        $msg = trim((string)($_POST['message'] ?? ''));
        if ($msg === '') {
            $error = 'Message cannot be empty.';
        } else {
            $r = whmcs_add_ticket_reply($id, $msg);
            if (($r['result'] ?? '') === 'success') {
                flash('ok', 'Reply sent.');
                header('Location: ticket_view.php?id=' . urlencode((string)$id)); exit;
            }
            $error = $r['message'] ?? 'Failed to send reply.';
        }
    }
}

$res = whmcs_get_ticket($id);
if (($res['result'] ?? '') !== 'success') {
    $error = $error ?: ($res['message'] ?? 'Failed to load ticket.');
}

$replies = $res['replies']['reply'] ?? [];
if (!is_array($replies)) $replies = [];

?>
<div class="container">
  <div class="pagehead">
    <div>
      <h1>Ticket #<?= e((string)$id) ?></h1>
      <p class="subtle"><?= e((string)($res['subject'] ?? '')) ?></p>
    </div>
    <div class="btnrow">
      <a class="btn btn--ghost" href="tickets.php">← Back</a>
    </div>
  </div>

  <?php if ($ok = flash('ok')): ?>
    <div class="alert alert--ok"><strong>Success</strong><?= e($ok) ?></div>
  <?php endif; ?>

  <?php if ($error): ?>
    <div class="alert alert--danger"><strong>Error</strong><?= e($error) ?></div>
  <?php endif; ?>

  <?php if (($res['result'] ?? '') === 'success'): ?>
    <div class="grid">
      <div class="card">
        <h3>Status</h3>
        <p class="big"><?= e((string)($res['status'] ?? '')) ?></p>
        <p class="small">Priority: <?= e((string)($res['priority'] ?? '')) ?></p>
      </div>
      <div class="card">
        <h3>Department</h3>
        <p class="big"><?= e((string)($res['deptname'] ?? '')) ?></p>
        <p class="small">Created: <?= e((string)($res['date'] ?? '')) ?></p>
      </div>
    </div>

    <h3 style="margin:16px 0 10px 0">Conversation</h3>
    <div class="thread">
      <div class="msg">
        <div class="msg__meta">
          <span><?= e((string)($res['name'] ?? 'You')) ?> (Client)</span>
          <span><?= e((string)($res['date'] ?? '')) ?></span>
        </div>
        <div class="msg__body"><?= e((string)($res['message'] ?? '')) ?></div>
      </div>

      <?php foreach ($replies as $rp): ?>
        <div class="msg">
          <div class="msg__meta">
            <span><?= e((string)($rp['name'] ?? 'Staff')) ?> (<?= e((string)($rp['admin'] ?? '') ? 'Staff' : 'Client') ?>)</span>
            <span><?= e((string)($rp['date'] ?? '')) ?></span>
          </div>
          <div class="msg__body"><?= e((string)($rp['message'] ?? '')) ?></div>
        </div>
      <?php endforeach; ?>
    </div>

    <h3 style="margin:16px 0 10px 0">Reply</h3>
    <form method="post" class="form">
      <input type="hidden" name="csrf" value="<?= e(frilix_csrf_token()) ?>" />
      <div class="field">
        <label>Message</label>
        <textarea name="message" required></textarea>
      </div>
      <div class="btnrow">
        <button class="btn btn--primary" type="submit">Send Reply</button>
      </div>
    </form>
  <?php endif; ?>
</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
