<?php
declare(strict_types=1);
$title = 'Open Ticket';
require_once __DIR__ . '/partials/header.php';
require_login();

$clientId = (int)$_SESSION['client']['id'];
$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!frilix_csrf_check($_POST['csrf'] ?? null)) {
        $error = 'Invalid CSRF token.';
    } else {
        $deptid  = trim((string)($_POST['deptid'] ?? '1'));
        $subject = trim((string)($_POST['subject'] ?? ''));
        $message = trim((string)($_POST['message'] ?? ''));
        $priority= trim((string)($_POST['priority'] ?? 'Medium'));

        if ($subject === '' || $message === '') {
            $error = 'Subject and message are required.';
        } else {
            $res = whmcs_open_ticket($clientId, $deptid, $subject, $message, $priority);
            if (($res['result'] ?? '') === 'success') {
                flash('ok', 'Ticket opened successfully.');
                header('Location: tickets.php'); exit;
            }
            $error = $res['message'] ?? 'Failed to open ticket.';
        }
    }
}
?>
<div class="container">
  <div class="pagehead">
    <div>
      <h1>Open a ticket</h1>
      <p class="subtle">Create a new support ticket in WHMCS.</p>
    </div>
    <div class="btnrow">
      <a class="btn btn--ghost" href="tickets.php">← Back</a>
    </div>
  </div>

  <?php if ($error): ?>
    <div class="alert alert--danger"><strong>Error</strong><?= e($error) ?></div>
  <?php endif; ?>

  <form method="post" class="form">
    <input type="hidden" name="csrf" value="<?= e(frilix_csrf_token()) ?>" />

    <div class="field">
      <label>Department ID</label>
      <input type="text" name="deptid" value="<?= e($_POST['deptid'] ?? '1') ?>" />
      <div class="footerhint">Set your WHMCS Support Department ID here (default 1).</div>
    </div>

    <div class="field">
      <label>Priority</label>
      <select name="priority">
        <?php
          $opts = ['Low','Medium','High'];
          $cur = $_POST['priority'] ?? 'Medium';
          foreach ($opts as $o) {
            $sel = ($o === $cur) ? 'selected' : '';
            echo "<option $sel>".e($o)."</option>";
          }
        ?>
      </select>
    </div>

    <div class="field">
      <label>Subject</label>
      <input type="text" name="subject" value="<?= e($_POST['subject'] ?? '') ?>" required />
    </div>

    <div class="field">
      <label>Message</label>
      <textarea name="message" required><?= e($_POST['message'] ?? '') ?></textarea>
    </div>

    <div class="btnrow">
      <button class="btn btn--primary" type="submit">Submit Ticket</button>
      <a class="btn btn--ghost" href="tickets.php">Cancel</a>
    </div>
  </form>
</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
