<?php
declare(strict_types=1);
$title = 'My Services';
require_once __DIR__ . '/partials/header.php';
require_login();

$clientId = (int)$_SESSION['client']['id'];
$status = trim((string)($_GET['status'] ?? ''));
$res = whmcs_get_clients_products($clientId, 50, 0, $status);

$items = $res['products']['product'] ?? [];
if (!is_array($items)) $items = [];

function svc_badge(string $status): array {
    $s = strtolower($status);
    if ($s === 'active') return ['Active','badge badge--ok'];
    if (in_array($s, ['suspended','terminated','cancelled'], true)) return [$status,'badge badge--danger'];
    if (in_array($s, ['pending'], true)) return ['Pending','badge badge--warn'];
    return [$status,'badge'];
}
?>
<div class="container">
  <div class="pagehead">
    <div>
      <h1>My Services</h1>
      <p class="subtle">Products / services synced from WHMCS.</p>
    </div>
    <div class="btnrow">
      <a class="btn btn--ghost" href="services.php">All</a>
      <a class="btn btn--ghost" href="services.php?status=Active">Active</a>
      <a class="btn btn--ghost" href="services.php?status=Pending">Pending</a>
      <a class="btn btn--ghost" href="services.php?status=Suspended">Suspended</a>
    </div>
  </div>

  <?php if (($res['result'] ?? '') !== 'success'): ?>
    <div class="alert alert--danger"><strong>Error</strong><?= e($res['message'] ?? 'Failed to load services') ?></div>
  <?php else: ?>
    <div class="tablewrap">
      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th>Product</th>
            <th>Domain</th>
            <th>Next Due</th>
            <th>Status</th>
            <th></th>
            <th></th>
          </tr>
        </thead>
        <tbody>
        <?php if (empty($items)): ?>
          <tr><td colspan="7">No services found.</td></tr>
        <?php else: foreach ($items as $p): 
          $pid = safe_int($p['id'] ?? 0);
          [$label,$cls] = svc_badge((string)($p['status'] ?? ''));
        ?>
          <tr>
            <td>#<?= e((string)$pid) ?></td>
            <td><?= e((string)($p['name'] ?? $p['productname'] ?? '')) ?></td>
            <td><?= e((string)($p['domain'] ?? '')) ?></td>
            <td><?= e((string)($p['nextduedate'] ?? '')) ?></td>
            <td><span class="<?= e($cls) ?>"><?= e($label) ?></span></td>
            <td><a class="btn btn--ghost" href="service_manage.php?id=<?= e((string)$pid) ?>">Manage</a></td>
            <td><a class="btn btn--ghost" href="go_service.php?id=<?= e((string)$pid) ?>">WHMCS</a></td>
          </tr>
        <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
