<?php
declare(strict_types=1);
$title = 'Service';
require_once __DIR__ . '/partials/header.php';
require_login();

$id = safe_int($_GET['id'] ?? 0);
if ($id <= 0) { header('Location: services.php'); exit; }

// WHMCS API does not have a simple "GetClientProduct" action in all versions.
// We'll fetch list and find the matching service.
$clientId = (int)$_SESSION['client']['id'];
$res = whmcs_get_clients_products($clientId, 200, 0, '');
$item = null;
if (($res['result'] ?? '') === 'success') {
    $items = $res['products']['product'] ?? [];
    if (is_array($items)) {
        foreach ($items as $p) {
            if (safe_int($p['id'] ?? 0) === $id) { $item = $p; break; }
        }
    }
}

?>
<div class="container">
  <div class="pagehead">
    <div>
      <h1>Service #<?= e((string)$id) ?></h1>
      <p class="subtle">Basic details shown here (from WHMCS).</p>
    </div>
    <div class="btnrow">
      <a class="btn btn--ghost" href="services.php">← Back</a>
      <a class="btn btn--primary" href="go_service.php?id=<?= e((string)$id) ?>">Open in WHMCS</a>
    </div>
  </div>

  <?php if (!$item): ?>
    <div class="alert alert--warn"><strong>Not found</strong>We could not find this service in your account.</div>
  <?php else: ?>
    <div class="grid">
      <div class="card">
        <h3>Product</h3>
        <p class="big"><?= e((string)($item['name'] ?? $item['productname'] ?? '')) ?></p>
        <p class="small">Status: <?= e((string)($item['status'] ?? '')) ?></p>
      </div>
      <div class="card">
        <h3>Domain</h3>
        <p class="big"><?= e((string)($item['domain'] ?? '—')) ?></p>
        <p class="small">Billing cycle: <?= e((string)($item['billingcycle'] ?? '')) ?></p>
      </div>
      <div class="card">
        <h3>Next Due</h3>
        <p class="big"><?= e((string)($item['nextduedate'] ?? '')) ?></p>
        <p class="small">Amount: <?= e((string)($item['recurringamount'] ?? '')) ?></p>
      </div>
      <div class="card">
        <h3>Server</h3>
        <p class="big"><?= e((string)($item['serverhostname'] ?? '—')) ?></p>
        <p class="small">IP: <?= e((string)($item['dedicatedip'] ?? '—')) ?></p>
      </div>
    </div>

    <div class="footerhint">
      Advanced actions (reboot, change password, etc.) depend on your WHMCS modules and allowed API actions.
      If you want, I can add buttons that call WHMCS Module Commands for specific products.
    </div>
  <?php endif; ?>
</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
