<?php
declare(strict_types=1);
$title = 'Manage Service';
require_once __DIR__ . '/partials/header.php';
require_login();

$serviceId = safe_int($_GET['id'] ?? 0);
if ($serviceId <= 0) { header('Location: services.php'); exit; }

$clientId = (int)$_SESSION['client']['id'];
$error = null;
$ok = null;

$res = whmcs_get_clients_products($clientId, 200, 0, '');
$item = null;
if (($res['result'] ?? '') === 'success') {
    $items = $res['products']['product'] ?? [];
    if (is_array($items)) {
        foreach ($items as $p) {
            if (safe_int($p['id'] ?? 0) === $serviceId) { $item = $p; break; }
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!frilix_csrf_check($_POST['csrf'] ?? null)) {
        $error = 'Invalid CSRF token.';
    } else {
        $action = (string)($_POST['action_name'] ?? '');
        $allowed = ['ChangePassword','Suspend','Unsuspend','Terminate','Reboot'];
        if (!in_array($action, $allowed, true)) {
            $error = 'This action is not allowed.';
        } else {
            $apiAction = 'Module' . $action;
            $extra = [];
            if ($action === 'ChangePassword') {
                $newpass = trim((string)($_POST['new_password'] ?? ''));
                if ($newpass === '') {
                    $error = 'New password is required.';
                } else {
                    $extra['newpassword'] = $newpass;
                    $extra['password'] = $newpass;
                }
            }
            if (!$error) {
                $payload = array_merge([
                    'action'    => $apiAction,
                    'serviceid' => (string)$serviceId,
                ], $extra);
                $r = whmcs_api($payload);
                if (($r['result'] ?? '') === 'success') {
                    $ok = 'Action executed successfully.';
                } else {
                    $error = $r['message'] ?? 'Action failed (module may not support it).';
                }
            }
        }
    }
}
?>
<div class="container">
  <div class="pagehead">
    <div>
      <h1>Manage Service #<?= e((string)$serviceId) ?></h1>
      <p class="subtle">Common service actions from the portal (module dependent).</p>
    </div>
    <div class="btnrow">
      <a class="btn btn--ghost" href="services.php">← Back</a>
      <a class="btn btn--ghost" href="go_service.php?id=<?= e((string)$serviceId) ?>">Open in WHMCS</a>
    </div>
  </div>

  <?php if ($ok): ?>
    <div class="alert alert--ok"><strong>Done</strong><?= e($ok) ?></div>
  <?php endif; ?>
  <?php if ($error): ?>
    <div class="alert alert--danger"><strong>Error</strong><?= e($error) ?></div>
  <?php endif; ?>

  <?php if ($item): ?>
    <div class="grid">
      <div class="card">
        <h3>Product</h3>
        <p class="big"><?= e((string)($item['name'] ?? $item['productname'] ?? '')) ?></p>
        <p class="small">Status: <?= e((string)($item['status'] ?? '')) ?></p>
      </div>
      <div class="card">
        <h3>Domain</h3>
        <p class="big"><?= e((string)($item['domain'] ?? '—')) ?></p>
        <p class="small">Next due: <?= e((string)($item['nextduedate'] ?? '')) ?></p>
      </div>
    </div>
  <?php endif; ?>

  <h3 style="margin:16px 0 10px 0">Actions</h3>
  <div class="footerhint">
    These buttons call WHMCS API actions like <code>ModuleSuspend</code>, <code>ModuleUnsuspend</code>, etc.
    If your server module doesn’t support an action, WHMCS will return an error.
  </div>

  <div class="grid" style="margin-top:12px">
    <div class="card" style="grid-column: span 12">
      <form method="post" class="form" style="margin-top:0">
        <input type="hidden" name="csrf" value="<?= e(frilix_csrf_token()) ?>" />
        <input type="hidden" name="action_name" value="ChangePassword" />
        <div class="field">
          <label>Change Service Password</label>
          <input type="password" name="new_password" placeholder="New password" />
        </div>
        <div class="btnrow">
          <button class="btn btn--primary" type="submit">Change Password</button>
        </div>
      </form>
    </div>

    <div class="card" style="grid-column: span 12">
      <div class="btnrow">
        <form method="post" style="display:inline">
          <input type="hidden" name="csrf" value="<?= e(frilix_csrf_token()) ?>" />
          <input type="hidden" name="action_name" value="Reboot" />
          <button class="btn btn--primary" type="submit">Reboot</button>
        </form>

        <form method="post" style="display:inline">
          <input type="hidden" name="csrf" value="<?= e(frilix_csrf_token()) ?>" />
          <input type="hidden" name="action_name" value="Suspend" />
          <button class="btn btn--danger" type="submit">Suspend</button>
        </form>

        <form method="post" style="display:inline">
          <input type="hidden" name="csrf" value="<?= e(frilix_csrf_token()) ?>" />
          <input type="hidden" name="action_name" value="Unsuspend" />
          <button class="btn" type="submit">Unsuspend</button>
        </form>

        <form method="post" style="display:inline">
          <input type="hidden" name="csrf" value="<?= e(frilix_csrf_token()) ?>" />
          <input type="hidden" name="action_name" value="Terminate" />
          <button class="btn btn--danger" type="submit" onclick="return confirm('Terminate service? This is irreversible.');">Terminate</button>
        </form>
      </div>
      <div class="footerhint" style="margin-top:10px">Disable “Terminate” if you don’t want clients to be able to terminate services.</div>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
