<?php
declare(strict_types=1);
$title = 'Profile';
require_once __DIR__ . '/partials/header.php';
require_login();

$clientId = (int)$_SESSION['client']['id'];

$error = null;
$ok = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!frilix_csrf_check($_POST['csrf'] ?? null)) {
        $error = 'Invalid CSRF token.';
    } else {
        $mode = (string)($_POST['mode'] ?? 'profile');

        if ($mode === 'profile') {
            $fields = [
                'firstname'   => trim((string)($_POST['firstname'] ?? '')),
                'lastname'    => trim((string)($_POST['lastname'] ?? '')),
                'companyname' => trim((string)($_POST['companyname'] ?? '')),
                'address1'    => trim((string)($_POST['address1'] ?? '')),
                'city'        => trim((string)($_POST['city'] ?? '')),
                'state'       => trim((string)($_POST['state'] ?? '')),
                'postcode'    => trim((string)($_POST['postcode'] ?? '')),
                'country'     => trim((string)($_POST['country'] ?? '')),
                'phonenumber' => trim((string)($_POST['phonenumber'] ?? '')),
            ];
            $fields = array_filter($fields, fn($v) => $v !== '');

            $r = whmcs_update_client($clientId, $fields);
            if (($r['result'] ?? '') === 'success') {
                $ok = 'Profile updated.';
                $d = whmcs_get_clients_details($clientId);
                $_SESSION['client']['name'] = trim(($d['client']['firstname'] ?? '') . ' ' . ($d['client']['lastname'] ?? ''));
            } else {
                $error = $r['message'] ?? 'Failed to update profile.';
            }
        } elseif ($mode === 'password') {
            $p1 = (string)($_POST['new_password'] ?? '');
            $p2 = (string)($_POST['new_password2'] ?? '');
            if ($p1 === '' || $p2 === '') {
                $error = 'Both password fields are required.';
            } elseif ($p1 !== $p2) {
                $error = 'Passwords do not match.';
            } elseif (strlen($p1) < 10) {
                $error = 'Use at least 10 characters.';
            } else {
                $r = whmcs_update_client_password($clientId, $p1);
                if (($r['result'] ?? '') === 'success') {
                    $ok = 'Password updated.';
                } else {
                    $error = $r['message'] ?? 'Failed to update password.';
                }
            }
        }
    }
}

$res = whmcs_get_clients_details($clientId);
$client = $res['client'] ?? [];
?>
<div class="container">
  <div class="pagehead">
    <div>
      <h1>Profile</h1>
      <p class="subtle">Edit your details without leaving the cloud portal.</p>
    </div>
  </div>

  <?php if ($ok): ?>
    <div class="alert alert--ok"><strong>Done</strong><?= e($ok) ?></div>
  <?php endif; ?>
  <?php if ($error): ?>
    <div class="alert alert--danger"><strong>Error</strong><?= e($error) ?></div>
  <?php endif; ?>

  <?php if (($res['result'] ?? '') !== 'success'): ?>
    <div class="alert alert--danger"><strong>Error</strong><?= e($res['message'] ?? 'Failed to load profile') ?></div>
  <?php else: ?>
    <div class="grid">
      <div class="card" style="grid-column: span 12">
        <h3>Edit details</h3>
        <form method="post" class="form">
          <input type="hidden" name="csrf" value="<?= e(frilix_csrf_token()) ?>" />
          <input type="hidden" name="mode" value="profile" />

          <div class="grid">
            <div class="field" style="grid-column: span 6">
              <label>First name</label>
              <input name="firstname" value="<?= e((string)($client['firstname'] ?? '')) ?>" />
            </div>
            <div class="field" style="grid-column: span 6">
              <label>Last name</label>
              <input name="lastname" value="<?= e((string)($client['lastname'] ?? '')) ?>" />
            </div>

            <div class="field" style="grid-column: span 12">
              <label>Company</label>
              <input name="companyname" value="<?= e((string)($client['companyname'] ?? '')) ?>" />
            </div>

            <div class="field" style="grid-column: span 12">
              <label>Address</label>
              <input name="address1" value="<?= e((string)($client['address1'] ?? '')) ?>" />
            </div>

            <div class="field" style="grid-column: span 4">
              <label>City</label>
              <input name="city" value="<?= e((string)($client['city'] ?? '')) ?>" />
            </div>
            <div class="field" style="grid-column: span 4">
              <label>State</label>
              <input name="state" value="<?= e((string)($client['state'] ?? '')) ?>" />
            </div>
            <div class="field" style="grid-column: span 4">
              <label>Post code</label>
              <input name="postcode" value="<?= e((string)($client['postcode'] ?? '')) ?>" />
            </div>

            <div class="field" style="grid-column: span 6">
              <label>Country</label>
              <input name="country" value="<?= e((string)($client['country'] ?? '')) ?>" />
            </div>
            <div class="field" style="grid-column: span 6">
              <label>Phone</label>
              <input name="phonenumber" value="<?= e((string)($client['phonenumber'] ?? '')) ?>" />
            </div>
          </div>

          <div class="btnrow">
            <button class="btn btn--primary" type="submit">Save changes</button>
          </div>
        </form>
      </div>

      <div class="card" style="grid-column: span 12">
        <h3>Change password</h3>
        <form method="post" class="form">
          <input type="hidden" name="csrf" value="<?= e(frilix_csrf_token()) ?>" />
          <input type="hidden" name="mode" value="password" />
          <div class="grid">
            <div class="field" style="grid-column: span 6">
              <label>New password</label>
              <input type="password" name="new_password" />
            </div>
            <div class="field" style="grid-column: span 6">
              <label>Confirm new password</label>
              <input type="password" name="new_password2" />
            </div>
          </div>
          <div class="btnrow">
            <button class="btn btn--primary" type="submit">Update password</button>
          </div>
          <div class="footerhint">Use a strong password (10+ chars). For best security, enable 2FA in WHMCS.</div>
        </form>
      </div>
    </div>
  <?php endif; ?>
</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
