<?php
declare(strict_types=1);
require_once __DIR__ . '/../../src/bootstrap.php';

$cfg = whmcs_config();
$title = $title ?? 'Client Portal';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <meta name="color-scheme" content="light dark">
  <title><?= e($title) ?> - FriliX Cloud</title>
  <link rel="stylesheet" href="assets/css/style.css?v=3" />
</head>
<body>
<header class="topbar">
  <div class="topbar__inner">
    <a class="brand" href="dashboard.php">
      <span class="brand__logo">☁️</span>
      <span class="brand__name">FriliX Cloud</span>
    </a>

    <button class="iconbtn" id="navToggle" aria-label="Toggle navigation">☰</button>

    <div class="topbar__right">
      <?php if (is_logged_in()): ?>
        <a class="pill" href="profile.php"><?= e($_SESSION['client']['name'] ?? 'Client') ?></a>
        <a class="pill pill--danger" href="logout.php">Logout</a>
      <?php else: ?>
        <a class="pill" href="login.php">Login</a>
      <?php endif; ?>
    </div>
  </div>
</header>

<div class="layout">
  <?php if (is_logged_in()): ?>
  <aside class="sidebar" id="sidebar">
    <nav class="nav">
      <a class="nav__item" href="dashboard.php">🏠 Dashboard</a>
      <a class="nav__item" href="services.php">🧩 My Services</a>
      <a class="nav__item" href="licenses.php">🔑 Licenses</a>
      <a class="nav__item" href="invoices.php">🧾 Invoices</a>
      <a class="nav__item" href="tickets.php">🎫 Tickets</a>
      <a class="nav__item" href="ticket_new.php">➕ Open Ticket</a>
      <a class="nav__item" href="profile.php">👤 Profile</a>
      <?php
        $sso = whmcs_create_sso((int)($_SESSION['client']['id'] ?? 0), '');
        if (($sso['result'] ?? '') === 'success' && !empty($sso['redirect_url'])):
      ?>
        <a class="nav__item nav__item--external" href="<?= e($sso['redirect_url']) ?>" target="_blank" rel="noopener">↗ Open WHMCS</a>
      <?php endif; ?>
    </nav>
  </aside>
  <?php endif; ?>

  <main class="content">
