<?php
declare(strict_types=1);
require_once __DIR__ . '/../src/bootstrap.php';

if (is_logged_in()) {
    header('Location: dashboard.php'); exit;
}

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!frilix_csrf_check($_POST['csrf'] ?? null)) {
        $error = 'Invalid CSRF token. Please refresh and try again.';
    } else {
        $email = trim((string)($_POST['email'] ?? ''));
        $pass  = (string)($_POST['password'] ?? '');

        if ($email === '' || $pass === '') {
            $error = 'Please enter email and password.';
        } else {
            $res = whmcs_validate_login($email, $pass);

            if (($res['result'] ?? '') === 'success') {
                $clientId = safe_int($res['userid'] ?? 0);
                $details  = whmcs_get_clients_details($clientId);

                $_SESSION['client'] = [
                    'id'    => $clientId,
                    'email' => $email,
                    'name'  => trim(($details['client']['firstname'] ?? '') . ' ' . ($details['client']['lastname'] ?? '')),
                    'currency' => $details['client']['currency_code'] ?? '',
                    'stats' => $details['stats'] ?? [],
                ];
                flash('ok', 'Welcome back!');
                header('Location: dashboard.php'); exit;
            }

            $error = $res['message'] ?? 'Login failed.';
        }
    }
}

$title = 'Login';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= e($title) ?> - FriliX Cloud</title>
  <link rel="stylesheet" href="assets/css/style.css?v=3" />
</head>
<body>
  <div class="auth">
    <div class="brand" style="display:flex">
      <span class="brand__logo">☁️</span>
      <span class="brand__name">FriliX Cloud</span>
    </div>

    <div class="container">
      <div class="pagehead" style="margin-bottom: 10px">
        <div>
          <h1>Sign in</h1>
          <p class="subtle">Use your WHMCS client email + password.</p>
        </div>
      </div>

      <?php if ($error): ?>
        <div class="alert alert--danger"><strong>Login failed</strong><?= e($error) ?></div>
      <?php endif; ?>
      <?php if ($ok = flash('ok')): ?>
        <div class="alert alert--ok"><strong>Done</strong><?= e($ok) ?></div>
      <?php endif; ?>

      <form method="post" class="form" autocomplete="on">
        <input type="hidden" name="csrf" value="<?= e(frilix_csrf_token()) ?>" />
        <div class="field">
          <label>Email</label>
          <input type="email" name="email" value="<?= e($_POST['email'] ?? '') ?>" required />
        </div>
        <div class="field">
          <label>Password</label>
          <input type="password" name="password" required />
        </div>
        <div class="btnrow">
          <button class="btn btn--primary" type="submit">Login</button>
          <a class="btn btn--ghost" href="https://service.modulecrafter.com/clientarea.php" target="_blank" rel="noopener">Forgot password?</a>
        </div>
        <div class="footerhint">Tip: For maximum security, enable 2FA in WHMCS client area.</div>
      </form>
    </div>
  </div>
</body>
</html>
