<?php
declare(strict_types=1);
$title = 'Licenses';
require_once __DIR__ . '/partials/header.php';
require_login();

require_once __DIR__ . '/../src/license.php';

$clientId = (int)$_SESSION['client']['id'];
$res = license_list($clientId);
?>
<div class="container">
  <div class="pagehead">
    <div>
      <h1>Licenses</h1>
      <p class="subtle">Manage licenses from the cloud portal (requires integration).</p>
    </div>
  </div>

  <?php if (($res['result'] ?? '') !== 'success'): ?>
    <div class="alert alert--warn">
      <strong>Not configured yet</strong>
      <?= e($res['message'] ?? 'License integration is not configured.') ?>
      <div class="footerhint">Connect your licensing module/API in <code>src/license.php</code>.</div>
    </div>
  <?php else: $items = $res['licenses'] ?? []; ?>
    <div class="tablewrap">
      <table>
        <thead>
          <tr>
            <th>License</th><th>Product</th><th>Status</th><th>Expires</th><th></th>
          </tr>
        </thead>
        <tbody>
          <?php if (empty($items)): ?>
            <tr><td colspan="5">No licenses found.</td></tr>
          <?php else: foreach ($items as $lic): ?>
            <tr>
              <td><?= e((string)($lic['key'] ?? $lic['license'] ?? '')) ?></td>
              <td><?= e((string)($lic['product'] ?? '')) ?></td>
              <td><span class="badge"><?= e((string)($lic['status'] ?? '')) ?></span></td>
              <td><?= e((string)($lic['expires'] ?? '')) ?></td>
              <td><a class="btn btn--ghost" href="license_view.php?id=<?= e((string)($lic['id'] ?? '')) ?>">View</a></td>
            </tr>
          <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
