<?php
declare(strict_types=1);
$title = 'License';
require_once __DIR__ . '/partials/header.php';
require_login();

require_once __DIR__ . '/../src/license.php';

$clientId = (int)$_SESSION['client']['id'];
$id = trim((string)($_GET['id'] ?? ''));
if ($id === '') { header('Location: licenses.php'); exit; }

$res = license_get($clientId, $id);
?>
<div class="container">
  <div class="pagehead">
    <div>
      <h1>License</h1>
      <p class="subtle">License details & actions.</p>
    </div>
    <div class="btnrow">
      <a class="btn btn--ghost" href="licenses.php">← Back</a>
    </div>
  </div>

  <?php if (($res['result'] ?? '') !== 'success'): ?>
    <div class="alert alert--warn"><strong>Not configured</strong><?= e($res['message'] ?? 'License integration not configured.') ?></div>
  <?php else: $lic = $res['license'] ?? []; ?>
    <div class="grid">
      <div class="card">
        <h3>Key</h3>
        <p class="big" style="font-size:16px; word-break:break-all"><?= e((string)($lic['key'] ?? $lic['license'] ?? '')) ?></p>
        <p class="small">Status: <?= e((string)($lic['status'] ?? '')) ?></p>
      </div>
      <div class="card">
        <h3>Product</h3>
        <p class="big"><?= e((string)($lic['product'] ?? '')) ?></p>
        <p class="small">Expires: <?= e((string)($lic['expires'] ?? '')) ?></p>
      </div>
    </div>
    <div class="footerhint">Implement actions (reset, reissue, change IP/domain) in <code>src/license.php</code>.</div>
  <?php endif; ?>
</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
