<?php
declare(strict_types=1);
$title = 'Invoices';
require_once __DIR__ . '/partials/header.php';
require_login();

$clientId = (int)$_SESSION['client']['id'];
$status = trim((string)($_GET['status'] ?? ''));
$res = whmcs_get_invoices($clientId, 50, 0, $status);

$items = $res['invoices']['invoice'] ?? [];
if (!is_array($items)) $items = [];

function invoice_badge(string $status): array {
    $s = strtolower($status);
    if (in_array($s, ['paid'], true)) return ['Paid', 'badge badge--ok'];
    if (in_array($s, ['unpaid'], true)) return ['Unpaid', 'badge badge--danger'];
    if (in_array($s, ['overdue'], true)) return ['Overdue', 'badge badge--warn'];
    return [$status, 'badge'];
}

?>
<div class="container">
  <div class="pagehead">
    <div>
      <h1>Invoices</h1>
      <p class="subtle">View and manage invoices pulled from WHMCS.</p>
    </div>
    <div class="btnrow">
      <a class="btn btn--ghost" href="invoices.php">All</a>
      <a class="btn btn--ghost" href="invoices.php?status=Paid">Paid</a>
      <a class="btn btn--ghost" href="invoices.php?status=Unpaid">Unpaid</a>
      <a class="btn btn--ghost" href="invoices.php?status=Overdue">Overdue</a>
    </div>
  </div>

  <?php if (($res['result'] ?? '') !== 'success'): ?>
    <div class="alert alert--danger"><strong>Error</strong><?= e($res['message'] ?? 'Failed to load invoices') ?></div>
  <?php else: ?>
    <div class="tablewrap">
      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th>Date</th>
            <th>Due Date</th>
            <th>Total</th>
            <th>Status</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
        <?php if (empty($items)): ?>
          <tr><td colspan="6">No invoices found.</td></tr>
        <?php else: foreach ($items as $inv): 
          $id = safe_int($inv['id'] ?? 0);
          [$label,$cls] = invoice_badge((string)($inv['status'] ?? ''));
        ?>
          <tr>
            <td>#<?= e((string)$id) ?></td>
            <td><?= e((string)($inv['date'] ?? '')) ?></td>
            <td><?= e((string)($inv['duedate'] ?? '')) ?></td>
            <td><?= e((string)($inv['total'] ?? '')) ?></td>
            <td><span class="<?= e($cls) ?>"><?= e($label) ?></span></td>
            <td><a class="btn btn--ghost" href="go_invoice.php?id=<?= e((string)$id) ?>">View</a></td>
          </tr>
        <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>

</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
