<?php
declare(strict_types=1);
$title = 'Invoice';
require_once __DIR__ . '/partials/header.php';
require_login();

$id = safe_int($_GET['id'] ?? 0);
if ($id <= 0) { header('Location: invoices.php'); exit; }

$res = whmcs_get_invoice($id);
if (($res['result'] ?? '') !== 'success') {
    $err = $res['message'] ?? 'Failed to load invoice';
}

?>
<div class="container">
  <div class="pagehead">
    <div>
      <h1>Invoice #<?= e((string)$id) ?></h1>
      <p class="subtle">Details pulled directly from WHMCS.</p>
    </div>
    <div class="btnrow">
      <a class="btn btn--ghost" href="invoices.php">← Back</a>
      <a class="btn btn--primary" href="go_invoice.php?id=<?= e((string)$id) ?>">Open in WHMCS (Pay)</a>
    </div>
  </div>

  <?php if (isset($err)): ?>
    <div class="alert alert--danger"><strong>Error</strong><?= e($err) ?></div>
  <?php else: ?>
    <div class="grid">
      <div class="card">
        <h3>Status</h3>
        <p class="big"><?= e((string)($res['status'] ?? '')) ?></p>
        <p class="small">Due: <?= e((string)($res['duedate'] ?? '')) ?></p>
      </div>
      <div class="card">
        <h3>Total</h3>
        <p class="big"><?= e((string)($res['total'] ?? '')) ?></p>
        <p class="small">Subtotal: <?= e((string)($res['subtotal'] ?? '')) ?></p>
      </div>
      <div class="card">
        <h3>Invoice Date</h3>
        <p class="big"><?= e((string)($res['date'] ?? '')) ?></p>
        <p class="small">Payment method: <?= e((string)($res['paymentmethod'] ?? '')) ?></p>
      </div>
      <div class="card">
        <h3>Balance</h3>
        <p class="big"><?= e((string)($res['balance'] ?? '')) ?></p>
        <p class="small">Tax: <?= e((string)($res['tax'] ?? '')) ?></p>
      </div>
    </div>

    <h3 style="margin:16px 0 10px 0">Line Items</h3>
    <div class="tablewrap">
      <table>
        <thead><tr><th>Description</th><th>Amount</th></tr></thead>
        <tbody>
          <?php
            $items = $res['items']['item'] ?? [];
            if (!is_array($items)) $items = [];
            if (empty($items)):
          ?>
            <tr><td colspan="2">No line items.</td></tr>
          <?php else: foreach ($items as $it): ?>
            <tr>
              <td><?= e((string)($it['description'] ?? '')) ?></td>
              <td><?= e((string)($it['amount'] ?? '')) ?></td>
            </tr>
          <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
