<?php
declare(strict_types=1);
require_once __DIR__ . '/../src/bootstrap.php';
require_login();

$serviceId = safe_int($_GET['id'] ?? 0);
if ($serviceId <= 0) { header('Location: services.php'); exit; }

$clientId = (int)$_SESSION['client']['id'];

// WHMCS product details page
$destination = 'clientarea.php?action=productdetails&id=' . $serviceId;

$sso = whmcs_create_sso($clientId, $destination);
if (($sso['result'] ?? '') === 'success' && !empty($sso['redirect_url'])) {
    header('Location: ' . $sso['redirect_url']);
    exit;
}

// Fallback: direct link (may require login)
$cfg = whmcs_config();
$baseUrl = rtrim($cfg['whmcs_base_url'] ?? 'https://service.modulecrafter.com/', '/') . '/';
header('Location: ' . $baseUrl . $destination);
exit;
