<?php
declare(strict_types=1);
$title = 'Dashboard';
require_once __DIR__ . '/partials/header.php';
require_login();

$clientId = (int)$_SESSION['client']['id'];
$currency = (string)($_SESSION['client']['currency'] ?? '');

$stats = $_SESSION['client']['stats'] ?? [];
$invoices_due = $stats['numdueinvoices'] ?? null;
$services_active = $stats['productsnumactive'] ?? null;
$tickets_open = $stats['ticketsnumopen'] ?? null;

?>
<div class="container">
  <div class="pagehead">
    <div>
      <h1>Dashboard</h1>
      <p class="subtle">Quick overview of your account.</p>
    </div>
    <div class="btnrow">
      <a class="btn" href="services.php">My Services</a>
      <a class="btn" href="invoices.php">Invoices</a>
      <a class="btn" href="tickets.php">Tickets</a>
      <a class="btn" href="licenses.php">Licenses</a>
    </div>
  </div>

  <?php if ($ok = flash('ok')): ?>
    <div class="alert alert--ok"><strong>Success</strong><?= e($ok) ?></div>
  <?php endif; ?>

  <div class="grid">
    <div class="card">
      <h3>Active Services</h3>
      <p class="big"><?= e((string)($services_active ?? '—')) ?></p>
      <p class="small">Products currently active</p>
    </div>
    <div class="card">
      <h3>Due Invoices</h3>
      <p class="big"><?= e((string)($invoices_due ?? '—')) ?></p>
      <p class="small">Invoices awaiting payment</p>
    </div>
    <div class="card">
      <h3>Open Tickets</h3>
      <p class="big"><?= e((string)($tickets_open ?? '—')) ?></p>
      <p class="small">Support requests currently open</p>
    </div>
    <div class="card">
      <h3>Account</h3>
      <p class="big"><?= e($_SESSION['client']['name'] ?? 'Client') ?></p>
      <p class="small"><?= e($_SESSION['client']['email'] ?? '') ?></p>
    </div>
  </div>

  <div class="footerhint">
    Need full WHMCS access? Use the “Open WHMCS” link in the sidebar (SSO).
  </div>
</div>
<?php require_once __DIR__ . '/partials/footer.php'; ?>
