# Cloud Client Portal (WHMCS API-driven)

This portal is meant to be hosted on **cloud.modulecrafter.com** and connects to your WHMCS at **service.modulecrafter.com** via the WHMCS API.

## 1) Requirements
- PHP 8.1+
- cURL enabled
- Sessions enabled

## 2) Setup
1. Upload the project files to `cloud.modulecrafter.com` (document root should point to the `/public` folder).
2. Copy `config/config.example.php` to `config/config.php` and edit values.
3. Copy your existing `frilix-api.php` logic into `src/whmcs.php` (or just keep as-is and only edit config).
4. Visit `/login.php`.

## 3) Security Notes (IMPORTANT)
- Do NOT commit your WHMCS API Identifier/Secret to git.
- Use HTTPS for cloud.modulecrafter.com.
- Consider restricting API credentials in WHMCS to only the required API actions and to your cloud server IP.

## 4) Pages Included
- Login / Logout
- Dashboard
- Invoices list + invoice view
- Services list + service view
- Tickets list + ticket view (reply) + open new ticket
- Profile (basic client details)

## 5) UI
- Fully responsive, mobile-first layout
- CSS is in `public/assets/css/style.css`
- Minimal JS in `public/assets/js/app.js`


## v4 Changes
- Invoice list 'View' now redirects to WHMCS invoice page via SSO (`go_invoice.php`).
- Services list 'View' now redirects to WHMCS product details via SSO (`go_service.php`).


## v5 Changes
- Internal **Service Management** page (`service_manage.php`) with module actions via WHMCS API.
- Profile **edit + password change** via WHMCS API.
- **Licenses** section scaffold (`licenses.php`) + integration stub (`src/license.php`).

### Notes
- Service actions depend on your WHMCS server module.
- Licensing needs your custom module/API endpoint wired into `src/license.php`.
